#ifndef _QUEUSYSTEM_CPP
#define _QUEUSYSTEM_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>

#include "QueuSystem.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool InitilizeQueu(LPQUEUSYSTEM lpQS, int iMaxItems)
{
    int LocalLoop = 0;

    lpQS->MaxItems = iMaxItems;

    lpQS->DataSize = (int *) calloc(lpQS->MaxItems, sizeof(int));
    lpQS->Data = (char **) calloc(lpQS->MaxItems, sizeof(char **));

    lpQS->UsedItems = 0;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool FreeQueu(LPQUEUSYSTEM lpQS)
{
    int LocalLoop = 0;

    while(LocalLoop < lpQS->UsedItems)
    {
        free(lpQS->Data[LocalLoop]);
        lpQS->DataSize[LocalLoop] = 0;
        LocalLoop++;
    }

    free(lpQS->Data);
    free(lpQS->DataSize);
	
	lpQS->UsedItems = 0;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool AddQueuItem(LPQUEUSYSTEM lpQS, void *vInBuf, int iInBufSz)
{
    if(lpQS->UsedItems == lpQS->MaxItems)
        return false;

    lpQS->DataSize[lpQS->UsedItems] = iInBufSz;
    lpQS->Data[lpQS->UsedItems] = (char *) calloc(iInBufSz + 1, 1);

    memcpy(lpQS->Data[lpQS->UsedItems], vInBuf, iInBufSz);

    lpQS->UsedItems++;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ReadQueuItem(LPQUEUSYSTEM lpQS, int iItem, void *vOutBuf)
{
    if(lpQS->UsedItems == 0)
        return -1;

    memcpy(vOutBuf, lpQS->Data[iItem], lpQS->DataSize[iItem]);

    return lpQS->DataSize[iItem];
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int GetQueuItem(LPQUEUSYSTEM lpQS, int iItem, void *vOutBuf)
{
    int DataSize = lpQS->DataSize[iItem];

    if(lpQS->UsedItems == 0)
        return -1;

    memcpy(vOutBuf, lpQS->Data[iItem], lpQS->DataSize[iItem]);

    DeleteQueuItem(lpQS, iItem);

    return DataSize;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool DeleteQueuItem(LPQUEUSYSTEM lpQS, int iItem)
{
    int LocalLoop = 0;

    if(lpQS->UsedItems == 0)
        return false;

    LocalLoop = iItem;

    free( lpQS->Data[iItem] );
    lpQS->DataSize[iItem] = 0;

    while(LocalLoop < lpQS->UsedItems)
    {
        lpQS->Data[LocalLoop] = lpQS->Data[LocalLoop + 1];
        lpQS->DataSize[LocalLoop] = lpQS->DataSize[LocalLoop +1];

        LocalLoop++;
    }

    lpQS->UsedItems--;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
